<?php

//******************************************************************************************************
//   ATTENTION: THIS FILE HEADER MUST REMAIN INTACT. DO NOT DELETE OR MODIFY THIS FILE HEADER.
//
//   Name: uu_finished_lib.php
//   Revision: 1.0
//   Date: 12/08/2007 2:43PM
//   Link: http://uber-uploader.sourceforge.net  
//   Initial Developer: Peter Schmandra
//   Description: Library for uu_finished.php
//
//   Licence:
//   The contents of this file are subject to the Mozilla Public
//   License Version 1.1 (the "License"); you may not use this file
//   except in compliance with the License. You may obtain a copy of
//   the License at http://www.mozilla.org/MPL/
// 
//   Software distributed under the License is distributed on an "AS
//   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
//   implied. See the License for the specific language governing
//   rights and limitations under the License.
//
//***************************************************************************************************************

/////////////////////////////////////////////////////////////////////////////
// Get/Set/Store uploaded file slot name, file name, file size and file type
/////////////////////////////////////////////////////////////////////////////
class FileInfo{
	var $slot;
	var $name;
	var $size = 0;
	var $type;

	function getSlot(){ return $this->slot; }
	function getName(){ return $this->name; }
	function getSize(){ return $this->size; }
	function getCType(){ return $this->type; }
	function setSlot($slot){ $this->slot = $slot; }
	function setName($name){ $this->name = $name; }
	function setSize($size){ $this->size = $size; }
	function setCType($type){ $this->type = $type; }
	function clearFileInfo(){ $this->slot = ''; $this->name = ''; $this->size = 0; $this->type = ''; }
}

//////////////////////////////////////////////////////////////////////////////////
// Parse the file info from $_PARAM_DATA and store in array of 'FileInfo' objects
//////////////////////////////////////////////////////////////////////////////////
function getFileInfo($_PARAM_DATA, $temp_dir, $temp_sid){
	$i = 0;
	$file_info_array = array();
	
	foreach($_PARAM_DATA as $file_slot => $file_name){ 
		if(preg_match("/^upfile_/i", $file_slot)){
			$file_info = new FileInfo;
			$file_info->setSlot($file_slot);
			$file_info->setName($file_name);
			
			if(isset($_PARAM_DATA[$file_name . '_size'])){ $file_info->setSize($_PARAM_DATA[$file_name . '_size']); }
			else{ 
				$file_size = @filesize($_POST_DATA['upload_dir'] . $file_name);
				$file_info->setSize($file_size);
			} 
			
			if(isset($_PARAM_DATA[$file_name . '_type']))$file_info->setCType($_PARAM_DATA[$file_name . '_type']);
			$file_info_array[$i] = $file_info;
			$i++;
		}
	}
	
	return $file_info_array;
}

/////////////////////////////////////////////////////////
// Get the post data from the param file (tmp_sid.param)
/////////////////////////////////////////////////////////
function getParamData($temp_dir, $temp_sid){
	$param_array = array();
	$buffer = '';
	$key = '';
	$value = '';
	$paramFileName = $temp_dir . $temp_sid . ".params";
	$fh = @fopen($paramFileName, 'r');
	
	if(!is_resource($fh)){ kak("<font color='red'>ERROR</font>: Failed to open $paramFileName"); }
	else{
		while(!feof($fh)){
			$buffer = fgets($fh, 8192);
			list($key, $value) = explode('=', trim($buffer));
			$value = str_replace("~EQLS~", "=", $value);
			$value = str_replace("~NWLN~", "\r\n", $value);
		
			if(isset($key) && isset($value) && strlen($key) > 0 && strlen($value) > 0){
				if(preg_match('/(.*)\[(.*)\]/i', $key, $match)){ $param_array[$match[1]][$match[2]] = $value; } 
				else{ $param_array[$key] = $value; }
			}
		}

		fclose($fh);
	
		if(isset($param_array['delete_param_file']) && $param_array['delete_param_file'] == 1){
			for($i = 0; $i < 5; $i++){
				if(@unlink($paramFileName)){ break; }
				else{ sleep(1); }
			}
		}
	} 
		
	return $param_array;
}

//////////////////////////////////////////////////
//  formatBytes($file_size) mixed file sizes
//  formatBytes($file_size, 0) KB file sizes
//  formatBytes($file_size, 1) MB file sizes etc
//////////////////////////////////////////////////
function formatBytes($bytes, $format=99){
	$byte_size = 1024;
	$byte_type = array(" KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
	
	$bytes /= $byte_size;
	$i = 0;
	
	if($format == 99 || $format > 7){
		while($bytes > $byte_size){
			$bytes /= $byte_size;
			$i++;
		}
	}
	else{
		while($i < $format){
			$bytes /= $byte_size;
			$i++;
		}
	}
	
	$bytes = sprintf("%1.2f", $bytes);
	$bytes .= $byte_type[$i];
	
	return $bytes;		
}

//////////////////////////////////////////
// Send an email with the upload results.
////////////////////////////////////////// 
function emailUploadResults($temp_sid, $upload_result, $email_to, $email_from, $email_subject, $start_time, $end_time, $html_email){
	$end_char = "\n";
	
	if($html_email){ 
		$headers .= 'Content-type: text/html; charset=utf-8; format=flowed' . "\r\n";
		$end_char = "<br>\n"; 
	}
	else{ $headers .= 'Content-type: text/plain; charset=utf-8; format=flowed' . "\r\n"; }
	
	$headers .= "From: " . $email_from . "\r\n";
	
	$message .= "SID: ". $temp_sid . $end_char;
	$message .= "Start Upload: ". date("M j, Y, g:i:s", $start_time) . $end_char;
	$message .= "End Upload: ". date("M j, Y, g:i:s", $end_time) . $end_char;
	$message .= "Remote IP: " . $_SERVER['REMOTE_ADDR']  . $end_char;
	$message .= "Browser: " . $_SERVER['HTTP_USER_AGENT'] . $end_char . $end_char;
	$message .= $upload_result;
	
	mail($email_to, $email_subject, $message, $headers);
} 

////////////////////////////////////////////////////////
// Create a '<tr><td>' string based on file upload info 
//////////////////////////////////////////////////////// 
function getFileInfoTable($_FILE_INFO, $link_to_upload, $path_to_upload){
	$file_list = null;
	$col = 0;
	
	for($i = 0; $i < count($_FILE_INFO); $i++){
		$file_slot = $_FILE_INFO[$i]->getSlot();
		$file_name = $_FILE_INFO[$i]->getName();
		$file_size = $_FILE_INFO[$i]->getSize();
		$formatted_file_size = formatBytes($file_size);
		$file_type = $_FILE_INFO[$i]->getCtype();
		
		if($col%=2){ $bg_col = "cccccc"; }
		else{ $bg_col = "dddddd"; }
		
		if($file_size > 0){
			if($link_to_upload == 1){
				$file_list .= "<tr><td align=\"center\" bgcolor=\"$bg_col\"><a href=\"$path_to_upload$file_name\" target=\"_blank\">$file_name</a></td><td align=\"center\" bgcolor=\"$bg_col\">$formatted_file_size</td></tr>\n"; 
			}
			else{ $file_list .= "<tr><td align=\"center\" bgcolor=\"$bg_col\">$file_name</td><td align=\"center\" bgcolor=\"$bg_col\">$formatted_file_size</td></tr>\n"; }
			
		}
		else{ $file_list .= "<tr><td align=\"center\" bgcolor=\"$bg_col\">&nbsp;$file_name&nbsp;</td><td align=\"center\" bgcolor=\"$bg_col\"><font color=\"red\">Failed To Upload</font></td></tr>\n"; }
		
		$col++;
	}
	
	return $file_list;
}

////////////////////////////////////////////////////////
// Create an email string based on file upload info 
//////////////////////////////////////////////////////// 
function getFileInfoEmail($_FILE_INFO , $link_to_upload_in_email, $unique_upload_dir, $unique_dir, $path_to_upload, $html_email){
	$email_file_list = null;
	$end_char = "\n";
	
	if($html_email){ $end_char = "<br>\n"; }
	
	for($i = 0; $i < count($_FILE_INFO); $i++){
		$file_slot = $_FILE_INFO[$i]->getSlot();
		$file_name = $_FILE_INFO[$i]->getName();
		$file_size = $_FILE_INFO[$i]->getSize();
		$formatted_file_size = formatBytes($file_size);
		$file_type = $_FILE_INFO[$i]->getCtype();
		
		if($file_size > 0){
			if($link_to_upload_in_email == 1){ $email_file_list .= "File Name: " . $path_to_upload . $file_name . "     File Size: " . $formatted_file_size . $end_char; }
			else{
				if($unique_upload_dir == 1){
					$email_file_list .= 'File Name: ' . $unique_dir . '/' . $file_name . "     File Size: " . $formatted_file_size . $end_char;
				}
				else{ $email_file_list .= 'File Name: ' . $file_name . "     File Size: " . $formatted_file_size . $end_char; }
			}
		}
		else{ $email_file_list .= 'File Name: ' . $file_name . "     File Size: Failed To Upload !" . $end_char; }
	}
	
	return $email_file_list;
}

?>