<?php 
require_once('../../includes/global.config.php');
if(!( (isset($_SESSION['UserType']) || isset($_SESSION['ModeratorUserType'])) && ($_SESSION['ModeratorUserType'] == "Moderator" || $_SESSION['UserType'] == "Administrator") ))
{   
    header("Location: ../index.php");
    exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>:: Welcome ::</title>
		<link href="../../css/style.css" rel="stylesheet" type="text/css" />

		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>GPTChat API Integration</title>
	</head>
	<style type="text/css">
		body {
		    font-family: Arial, sans-serif;
		    background-color: #f0f0f0;
		}

		.chat-container {
		    width: 100%;
		    max-width: 600px;
		    margin: 40px auto;
		    background-color: #fff;
		    border-radius: 5px;
		    box-shadow: 0 3px 10px rgba(0,0, 0, 0.1);
			display: flex;
			flex-direction: column;
		}

		.chat-output {
			flex-grow: 1;
			padding: 20px;
			overflow-y: auto;
			max-height: 400px;
		}

		.chat-output p {
			margin: 10px 0;
		}

		.user-message {
			text-align: right;
		/* font-weight: bold; */
		}

		.bot-message {
			text-align: left;
			font-weight: normal;
		}

		.chat-input-form {
			display: flex;
			align-items: center;
			padding: 10px;
			background-color: #f0f0f0;
			border-top: 1px solid #e0e0e0;
		}

		.chat-input {
			flex-grow: 1;
			border: none;
			border-radius: 3px;
			padding: 10px;
			margin-right: 10px;
		}

		.chat-submit {
			padding: 10px 20px;
			background-color: #007bff;
			color: #fff;
			font-weight: bold;
			border: none;
			cursor: pointer;
			border-radius: 3px;
		}

		.chat-submit:hover {
			background-color: #0056b3;
		}


		div.user-message, div.bot-message {
		    padding: 16px;
		    font-size: 16px;
		    line-height: 26px;
		    background: transparent;
		    width: 80%;
		    border-radius: 10px;
		    margin-top: 10px;
		    margin-bottom: 10px;
		    margin-top: 10px;
		    margin-bottom: 10px;
		    border: 1px  solid #e7e7e7;
		    box-shadow: 0 0 19px #00000017;
		}
		div.user-message {
		    margin-left: auto;
		    border-radius: 10px 10px 0 10px;
		}
		div.bot-message {
		    border-radius: 10px 10px 0 10px;
		  
		}

		/**
		*loader css
		*/
		.loader {
		    width: 48px;
		    height: 48px;
		    border: 5px solid #f0f0f0;
		    border-bottom-color: transparent;
		    border-radius: 50%;
		    display: inline-block;
		    box-sizing: border-box;
		    animation: rotation 1s linear infinite;
		}

		@keyframes rotation {
		    0% {
		        transform: rotate(0deg);
		    }
		    100% {
		        transform: rotate(360deg);
		    }
		} 
	</style>
	<?php 
		$audio_transcribe_exist = '';
		$audio_summary_exist = '';
		$audio_prefix = '';
		$audio_sufix = '';
		if(isset($_REQUEST['id']) && $_REQUEST['id'] != ''){
		    $com_data = sp_return_communication_data_to_transcribe($_REQUEST['id']);

		    //audio transcribetion 
		    $audio_transcribe_exist = $com_data['audio_transcribe_exist'];
		    if( empty( $com_data['audio_transcribe_exist'] ) && !empty( $com_data['s3_url'] ) ){

		        $audio_transcribe_exist = sp_get_audio_transcribe($_REQUEST['id'],$com_data['s3_url']);

		    }

		    $audio_sufix = $com_data['summary_sufix'];
		    $audio_prefix = sp_get_openai_summery_prefix_text();
		    // echo $com_data['summary_sufix'];die;
		    $audio_summary_exist = $com_data['audio_summary_exist'];
		    if($audio_transcribe_exist != ''){
		        $audio_summary_exist = sp_get_openai_audio_transcribe_summery($_REQUEST['id'], $audio_transcribe_exist, $com_data['summary_sufix']);
		    }

		}else{
		    $audio_transcribe_exist = '';
		    $audio_summary_exist = '';
		    $audio_prefix = '';
			$audio_sufix = '';
		}

		
	?>
	<body>
		<div class="chat-container">
			<div id="chat-output" class="chat-output">
				<div class="user-message"><?php echo $audio_prefix; ?></div>
				<div class="user-message"><?php echo $audio_transcribe_exist; ?></div>
				<div class="user-message"><?php echo $audio_sufix; ?></div>
				<div class="bot-message"><?php echo $audio_summary_exist; ?></div>
			</div>
			<form id="chat-form" class="chat-input-form">
				<input type="hidden" name="prev_user_msg" id="prev_user_msg" value="<?php echo $audio_transcribe_exist; ?>">
				<input type="hidden" name="prev_ai_msg" id="prev_ai_msg" value="<?php echo $audio_summary_exist; ?>">
				<textarea id="chat-input" class="chat-input" placeholder="Type your message here" autocomplete="off"></textarea>
				<button type="submit" class="chat-submit">Send</button>
			</form>
		</div>
	</body>

	<script type="text/javascript">
		const chatForm = document.getElementById("chat-form");
		const chatInput = document.getElementById("chat-input");
		const chatAiPrev = document.getElementById("prev_ai_msg");
		const chatUserPrev = document.getElementById("prev_user_msg");
		const chatOutput = document.getElementById("chat-output");

		chatForm.addEventListener("submit", async (e) => {
		    e.preventDefault();
		    const message = chatInput.value.trim();
		    const aiprev = chatAiPrev.value.trim();
		    const userprev = chatUserPrev.value.trim();
		    if (!message) return;

		    chatOutput.innerHTML += `<div class="user-message">${message}</div>`;
		    chatInput.value = "";
		    chatOutput.scrollTop = chatOutput.scrollHeight;
		    chatOutput.innerHTML += `<div class="bot-message loader-msg"><span class="loader"></span></div>`;
		    
		    const response = await fetch("gptchat.php", {
		        method: "POST",
		        headers: {
		            "Content-Type": "application/json",
		        },
		        body: JSON.stringify({ message, aiprev, userprev }),
		    });

		    if (response.ok) {
		        const data = await response.json();
		        document.querySelectorAll('.loader-msg')[0].remove();
		        if (data.choices && data.choices[0] && data.choices[0].message && data.choices[0].message['content']) {
		        	chatUserPrev.value = message;
		        	chatAiPrev.value = data.choices[0].message['content'];
		            chatOutput.innerHTML += `<div class="bot-message">${data.choices[0].message['content']}</div>`;
		        } else {
		            console.error("Error: Unexpected response format", data);
		            chatOutput.innerHTML += `<div class="bot-message">Error: Unexpected response format</div>`;
		        }
		        chatOutput.scrollTop = chatOutput.scrollHeight;
		    } else {
		        chatOutput.innerHTML += `<div class="bot-message">Error communicating with GPTChat API</div>`;
		        console.error("Error communicating with GPTChat API");
		    }
		});
	</script>
</html>
<?php
function generate_transcribe_and_summery($s3_url, $id){
	$data = array();
	if($s3_url == '' || $id == ''){
		$data['audio_transcribe'] = '';
	    $data['audio_summary'] = '';

	    return $data;
	}
	
	$ch = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // replace with your API token
    $YOUR_API_TOKEN 		= "0101384ef56344ac9ddec4997ff8c070"; // URL of the file to transcribe
    $FILE_URL 				= $s3_url; // AssemblyAI transcript endpoint (where we submit the file)
    $transcript_endpoint 	= "https://api.assemblyai.com/v2/transcript";// request parameters where speaker_labels has been enabled
    $data = array(
      "audio_url" => $FILE_URL,
      "speaker_labels" => true
    );

    // HTTP request headers
    $headers = array(
        "authorization: 67e5f2755a964a33b0ee1508a73ef0b8",
        "content-type: application/json"
    );

    // submit for transcription via HTTP request
    $curl = curl_init($transcript_endpoint);

    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($curl);
    $response = json_decode($response, true);

    curl_close($curl);

    # polling for transcription completion
    $transcript_id = $response['id'];
    $polling_endpoint = "https://api.assemblyai.com/v2/transcript/" . $transcript_id;

    while (true) {
        $polling_response = curl_init($polling_endpoint);

        curl_setopt($polling_response, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($polling_response, CURLOPT_RETURNTRANSFER, true);

        $transcription_result = json_decode(curl_exec($polling_response), true);

        if ($transcription_result['status'] === "completed") {
            $utterances = $transcription_result['utterances'];

            // Iterate through each utterance and print the speaker and the text they spoke
            $response_data = '';
            foreach ($utterances as $utterance) {
                $speaker = $utterance['speaker'];
                $text = $utterance['text'];
                $response_data .= "Speaker $speaker: $text";
                $response_data .= '<br>';
            }
            break;
        } else if ($transcription_result['status'] === "error") {
            throw new Exception("Transcription failed: " . $transcription_result['error']);
        } else {
            sleep(3);
        }
    }

    $audio_transcribe = $response_data;


    //audio trascribe summery start
	$pretext = mysql_query("select * from tbldfu_chat_gpt_settings where type='summary_instructions'");
	$pretext_details = mysql_fetch_assoc($pretext); 
	mysql_free_result($pretext);
	if(isset($pretext_details['message']) && $pretext_details['message'] != ''){
	    $chatgpt_pretext = $pretext_details['message'].' : ';
	}else{
	    $chatgpt_pretext = 'summaries the audio: ';
	}

	$api_key = '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';

    $url = 'https://api.openai.com/v1/chat/completions';
    $chat_headers = [
        "Authorization: Bearer $api_key",
        "Content-Type: application/json",
    ];

    $chat_data = [
        'model' => 'gpt-3.5-turbo',
        'messages' => [
            [
                "role" => "system",
                "content" => "You are a helpful assistant."
            ],
            [
                "role" => "user",
                "content" => $chatgpt_pretext . $audio_transcribe,
            ],
        ],
        'temperature' => 1.0,
        'max_tokens' => 256,
        'frequency_penalty' => 0,
        'presence_penalty' => 0,
     ];

    $jsonString = json_encode($chat_data);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonString);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $chat_headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    $result = json_decode($response);
    curl_close($ch);

    $summaries = $result->choices[0]->message->content;

    if(isset($result->choices[0]->message->content)){
        $queryupdate = "update tbldfu_cust_communication set audio_transcribe='".mysql_real_escape_string($audio_transcribe)."', audio_summary='".mysql_real_escape_string($summaries)."' where id = '".$id."' ";
        mysql_query($queryupdate);
    }

    $data['audio_transcribe'] = $audio_transcribe;
    $data['audio_summary'] = $summaries;

    return $data;
}
?>