<?php
    // Set the minimum PHP version required
    if (version_compare(PHP_VERSION, '8.3.0', '<')) {
        die("PHP version must be 8.3 or newer.");
    }

    $sp_custom_log_folder = 'sp_custom_logs/';

    $sp_error_log_file = $sp_custom_log_folder . 'error_log.txt';

    // Check the folder exits or not
    if ( ! file_exists ( $sp_custom_log_folder ) ) {
        mkdir( $sp_custom_log_folder, 0777, true );
    }

    // Check the common error file exits or not
    if ( ! file_exists ( $sp_error_log_file ) ) {
        fopen( $sp_error_log_file, 'a') ;
    }
    
    if( isset( $_POST["upload_file"] ) && ! empty( $_POST["upload_file"] ) ){
        $posted = $_POST;
        $files = $_FILES;

        // unset the hook
        unset( $posted["upload_file"] );
        
        $php_file = isset( $files["php_file"] ) && ! empty( $files["php_file"] ) ? $files["php_file"] : '';
        
        if ($php_file['error'] == UPLOAD_ERR_OK) {
            
            $fileTmpPath = $php_file['tmp_name'];
            $fileName = $php_file['name'];
            $fileExtension = pathinfo($fileName, PATHINFO_EXTENSION);
            
            if ($fileExtension !== 'php') {
                die("Please upload a valid PHP file.");
            }
            
            $fileContent = file_get_contents($fileTmpPath);
            
            ob_start();
            
            error_reporting(E_ALL);
            ini_set('display_errors', 1);
            
            set_error_handler(function($severity, $message, $file, $line) use ($fileTmpPath) {
                // echo "Error: [$severity] $message in $file on line $line<br>";

                // $errorMsg = "Error: [$severity] $message in $file on line $line\n";
                // echo nl2br($errorMsg);
                // error_log($errorMsg, 3, 'sp_custom_logs/error_log.txt');

                $fileLines = file($fileTmpPath);
                $errorLine = isset($fileLines[$line - 1]) ? $fileLines[$line - 1] : "Line not found in file.";

                $errorMsg = "Error: [$severity] $message in $file on line $line\n";
                $errorMsg .= "Error Line: " . trim($errorLine) . "\n";
                echo nl2br($errorMsg);
                error_log($errorMsg, 3, 'sp_custom_logs/error_log.txt');
            });
            
            try {
                global $sp_dbcon;
                $fileContent = preg_replace_callback('/(mysql_query\s*\(\s*[^,]+,\s*)([^)]+)(\);)/', function($matches) {
                    
                    return $matches[1] . '$result = ' . $matches[2] . ';if (!$result) {echo "SQL Error: " . mysql_error($sp_dbcon); die();}' . $matches[3];
                }, $fileContent);

                eval('?>' . $fileContent);
            } catch (Throwable $e) {
                // echo "Exception: " . $e->getMessage();

                echo "Exception on line " . $e->getLine() . ": " . $e->getMessage();
                error_log("Exception on line " . $e->getLine() . ": " . $e->getMessage(), 3, 'sp_custom_logs/error_log.txt');
            }
    
            $errorOutput = ob_get_contents();
            ob_end_clean();
    
            if (!empty($errorOutput)) {
                $errorFileName = $sp_custom_log_folder . 'error_log_' . time() . "-" . $fileName . '.txt';
                file_put_contents($errorFileName, $errorOutput);
                $responseMessage =  "Errors were encountered during execution. Please check the error log: $errorFileName";
            } else {
                $responseMessage = "The PHP file executed successfully with no errors.";
            }
        } else {
            $responseMessage =  "File upload error: " . $uploadedFile['error'];
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Convert Your PHP File Code to PHP 7.2</title>
    <style id="php-convertor_css">
        @import url("https://fonts.googleapis.com/css2?family=Poppins:wght@500;700&display=swap");

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: "Poppins", sans-serif;
            font-weight: 500;
            background: linear-gradient(to bottom right, #e3e4da, #e4deda);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 110vh;
            color: #3f3e68;
            font-size: 16px;
        }

        .container {
            display: flex;
            align-items: center;
            max-width: 431px;
            width: 100%;
            flex-direction: column;
            gap: 15px;
        }

        .sign-in-card {
            background-color: #fff;
            border-radius: 15px;
            padding: 50px;
            border: 28px solid #fefaf3;
        }

        h2 {
            font-size: 32px;
            margin-bottom: 20px;
            font-weight: 700;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 16px;
        }

        label {
            margin-bottom: -10px;
        }

        input[type="file"] {
            padding: 16px;
            border: 1px solid #a7a6c3;
            border-radius: 5px;
            font-family: "Poppins", sans-serif;
            font-weight: 500;
            font-size: 16px;
            color: #3f3e68;
            outline: none;
            margin-bottom: 15px;
        }

        input[type="submit"] {
            background-color: #3f3e68;
            color: #fff;
            font-family: "Poppins", sans-serif;
            font-weight: 500;
            font-size: 16px;
            padding: 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        input[type="submit"]:hover {
            background-color: #2a2a5a;
        }
    </style>
</head>
<body>
    <div class="form-container container">
        <div class="sign-in-card">
            <h2>Version Convertor</h2>
            <form action="" method="POST" enctype="multipart/form-data">
                <label for="php_file">Upload a PHP file:</label>
                <input type="file" name="php_file" id="php_file" accept=".php" required>
                <input type="submit" value="Upload File" name="upload_file">
              </form>
        </div>
        <div class="sign-in-card" <?php echo isset( $responseMessage ) && ! empty( $responseMessage ) ? "" : "style=display:none" ?>>
            <h2>File Report</h2>
            <span><?php if ( isset( $responseMessage ) && ! empty( $responseMessage ) ) { echo $responseMessage; } ?></span>
        </div>
    </div>
</body>
</html>