<?php
//******************************************************************************************************
//   ATTENTION: THIS FILE HEADER MUST REMAIN INTACT. DO NOT DELETE OR MODIFY THIS FILE HEADER.
//
//   Name: uu_get_status.php
//   Revision: 3.0
//   Date: 25/08/2007 2:31PM
//   Link: http://uber-uploader.sourceforge.net  
//   Initial Developer: Peter Schmandra
//   Description: Gather stats on an existing upload
//
//   Licence:
//   The contents of this file are subject to the Mozilla Public
//   License Version 1.1 (the "License"); you may not use this file
//   except in compliance with the License. You may obtain a copy of
//   the License at http://www.mozilla.org/MPL/
// 
//   Software distributed under the License is distributed on an "AS
//   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
//   implied. See the License for the specific language governing
//   rights and limitations under the License.
//
//***************************************************************************************************************

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// The following possible query string formats are assumed
//
// 1. ?temp_sid=random_sid_number&temp_dir=path_to_temp_dir&start_time=upload_start_time&total_upload=total_upload_size&rnd_id=some_random_number 
// 2. ?cmd=about
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("uu_conlib.php");

$THIS_VERSION = "3.0";

if(isset($_GET['cmd']) && $_GET['cmd'] == 'about'){ kak("<u><b>UBER-UPLOADER GET UPLOAD STATUS</b></u><br>UBER-UPLOADER VERSION =  <b>" . $UBER_VERSION . "</b><br>UU_GET_STATUS = <b>" . $THIS_VERSION . "<b><br>\n"); }
elseif(!preg_match("/^[a-zA-Z0-9]{32}$/", $_GET['temp_sid']) || !isset($_GET['temp_dir']) || !isset($_GET['start_time']) || !isset($_GET['total_upload_size'])){ kak("<font color='red'>ERROR</font>: Invalid parameters passed<br>"); }

$read_status = GetBytesRead($_GET['temp_dir'], $_GET['temp_sid']);

if($read_status->active && $read_status->bytes_uploaded < $_GET['total_upload_size']){
	$lapsed_time = time() - $_GET['start_time'];
	
	echo "if(typeof setProgressStatus == 'function'){ setProgressStatus(" . $read_status->bytes_uploaded . "," . $lapsed_time . "," .  $read_status->uploaded_files . "); }"; 
}
else{
	echo "if(typeof get_data_loop != 'undefined' && get_data_loop != 'null'){ get_data_loop = false; }";
	
	if($embedded_upload_results){ echo "if(typeof hideProgressBar == 'function'){ hideProgressBar(); }"; }
}

class ReadStatus{
	var $active = 0;
	var $uploaded_files = 0;
	var $bytes_uploaded = 0;
}

///////////////////////////////////////////////////////////////////////////////
// Return the current size of the $_GET['temp_dir_sid'] - flength file size. //
///////////////////////////////////////////////////////////////////////////////
function GetBytesRead($temp_dir, $temp_sid){
	$read_status = new ReadStatus;
	$temp_dir_sid = $temp_dir . $temp_sid;
	
	if(is_dir($temp_dir_sid) && is_file($temp_dir_sid . '/flength')){
		if($handle = opendir($temp_dir_sid)){
			while(false !== ($file = readdir($handle))){
				if(($file != '.') && ($file != '..') && ($file != 'flength')){ 
					$read_status->bytes_uploaded += filesize($temp_dir_sid . '/' . $file);
					$read_status->uploaded_files++;
				}
			}
			closedir($handle);
			
			$read_status->active = 1;
			
			if($read_status->uploaded_files > 0){ $read_status->uploaded_files -= 1; }
		}
	}
	
	return $read_status;
}
?>