//******************************************************************************************************
//   ATTENTION: THIS FILE HEADER MUST REMAIN INTACT. DO NOT DELETE OR MODIFY THIS FILE HEADER.
//
//   Name: uu_file_upload.js
//   Revision: 2.3
//   Date: 09/09/2007 12:17PM
//   Link: http://uber-uploader.sourceforge.net
//   Initial Developer: Peter Schmandra  http://www.webdice.org
//
//   Licence:
//   The contents of this file are subject to the Mozilla Public
//   License Version 1.1 (the "License"); you may not use this file
//   except in compliance with the License. You may obtain a copy of
//   the License at http://www.mozilla.org/MPL/
// 
//   Software distributed under the License is distributed on an "AS
//   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
//   implied. See the License for the specific language governing
//   rights and limitations under the License.
//
//***************************************************************************************************************

var upload_range = 1;
var get_status_speed;
var get_status_url;
var get_data_loop = false;
var seconds = 0;
var minutes = 0;
var hours = 0;
var info_width = 0;
var info_bytes = 0;
var info_time_width = 500;
var info_time_bytes = 15;
var cedric_hold = true;
var total_upload_size = 0;
var total_Kbytes = 0;
var AJAX_req = false;

// Check the file format before uploading
function checkFileNameFormat(){
	/*if(!check_file_name_format){ return false; }
	
	for(var i = 0; i < upload_range; i++){
		if(document.form_upload.elements['upfile_' + i].value != ""){
			var string = document.form_upload.elements['upfile_' + i].value;
			var num_of_last_slash = string.lastIndexOf("\\");

			if(num_of_last_slash < 1){ num_of_last_slash = string.lastIndexOf("/"); }

			var file_name = string.slice(num_of_last_slash + 1, string.length);
			var re = /^[\w][\w\.\-]{1,48}$/i;
				
			if(!re.test(file_name)){	
				alert("Sorry, uploading files in this format is not allowed. Please ensure your file names follow this format. \n\n1. Entire file cannot exceed 48 characters\n2. Format should be filename.extension or filename\n3. Legal characters are 1-9, a-z, A-Z, '_', '-'\n");
				return true;
			}
		}
	}
	return false;*/
}

// Check for illegal file extentions
function checkDisallowFileExtensions(){
	if(!check_disallow_extensions){ return false; }
	
	for(var i = 0; i < upload_range; i++){
		if(document.form_upload.elements['upfile_' + i].value != ""){
			if(document.form_upload.elements['upfile_' + i].value.match(disallow_extensions)){
				var string = document.form_upload.elements['upfile_' + i].value;
				var num_of_last_slash = string.lastIndexOf("\\");

				if(num_of_last_slash < 1){ num_of_last_slash = string.lastIndexOf("/"); }

				var file_name = string.slice(num_of_last_slash + 1, string.length);
				var file_extension = file_name.slice(file_name.indexOf(".")).toLowerCase();
				
				alert('Sorry, uploading a file with the extension "' + file_extension + '" is not allowed.');
				return true;
			}
		}
	}
	return false;
}

// Check for legal file extentions
function checkAllowFileExtensions(){
	if(!check_allow_extensions){ return false; }
	
	for(var i = 0; i < upload_range; i++){
		if(document.form_upload.elements['upfile_' + i].value != ""){
			if(!document.form_upload.elements['upfile_' + i].value.match(allow_extensions)){
				var string = document.form_upload.elements['upfile_' + i].value;
				var num_of_last_slash = string.lastIndexOf("\\");

				if(num_of_last_slash < 1){ num_of_last_slash = string.lastIndexOf("/"); }

				var file_name = string.slice(num_of_last_slash + 1, string.length);
				var file_extension = file_name.slice(file_name.indexOf(".")).toLowerCase();
				
				alert('Sorry, uploading a file with the extension "' + file_extension + '" is not allowed.');
				return true;
			}
		}
	}
	return false;
}

// Make sure the user selected at least one file
function checkNullFileCount(){
	if(!check_null_file_count){ return false; }

	var null_file_count = 0;

	for(var i = 0; i < upload_range; i++){
		if(document.form_upload.elements['upfile_' + i].value == ""){ null_file_count++; }
	}

	if(null_file_count == upload_range){
		alert("Please Choose A File To Upload.");
		return true;
	}
	else{ return false; }
}

// Make sure the user is not uploading duplicate files
function checkDuplicateFileCount(){
	if(!check_duplicate_file_count){ return false; }

	var duplicate_flag = false;
	var file_count = 0;
	var duplicate_msg = "Duplicate Upload Files Detected.\n\n";
	var file_name_array = new Array();

	for(var i = 0; i < upload_range; i++){
		if(document.form_upload.elements['upfile_' + i].value != ""){
			var string = document.form_upload.elements['upfile_' + i].value;
			var num_of_last_slash = string.lastIndexOf("\\");

			if(num_of_last_slash < 1){ num_of_last_slash = string.lastIndexOf("/"); }

			var file_name = string.slice(num_of_last_slash + 1, string.length);
			            
			file_name_array[i] = file_name;
		}
	}

	var num_files = file_name_array.length;
       
	for(var i = 0; i < num_files; i++){
		for(var j = 0; j < num_files; j++){
			if(file_name_array[i] == file_name_array[j] && file_name_array[i] != null){ file_count++; }
		}
		if(file_count > 1){
			duplicate_msg += 'Duplicate file "' + file_name_array[i] + '" detected in slot ' + (i + 1) + ".\n";
			duplicate_flag = true;
		}
		file_count = 0;
	}

	if(duplicate_flag){
		alert(duplicate_msg);
		return true; 
	}
	else{ return false; }
}

// Handle user pressing 'Enter' in the upload slots
function handleKey(event){
        if(document.all){ if(window.event.keyCode == 13){ return false; } }
        else{ if(event && event.which == 13){ return false; } }
}

function handle_upload_button()

{
 	//if(document.form_upload.upfile_0.value!='')
	//{
		//if(document.getElementById('upload_button').disabled == true)
		document.getElementById('upload_button').disabled = false;
	//}
	//else
	//document.getElementById('upload_button').disabled = true;
	
}

// Submit the upload form
function uploadFiles( obj){
	if(checkFileNameFormat()){ return false; }
	if(checkDisallowFileExtensions()){ return false; }
	if(checkAllowFileExtensions()){ return false; }
	//if(checkNullFileCount()){ return false; }
	if(checkDuplicateFileCount()){ return false; }
	if(show_files_uploaded){ 
		var total_uploads = 0;

		for(var i = 0; i < upload_range; i++){
			if(document.form_upload.elements['upfile_' + i].value != ""){ total_uploads++; }
		}

		document.getElementById('total_uploads').innerHTML = total_uploads;
		//alert(total_uploads);
	}
	
	document.form_upload.submit();
	//document.getElementById('upload_button').disabled = true;
	obj.disabled = true;
	for(var i = 0; i < upload_range; i++){ document.form_upload.elements['upfile_' + i].disabled = true; }

	iniProgressRequest();
}

// Reset the file upload page 
function resetForm(){ location.href = self.location; }

// Hide the progress bar
function hideProgressBar(){ document.getElementById('progress_bar').style.display = "none"; }

// Initialize the file upload page
function iniFilePage(){
	resetProgressBar();

	for(var i = 0; i < upload_range; i++){
		document.form_upload.elements['upfile_' + i].disabled = false;
		document.form_upload.elements['upfile_' + i].value = "";
	}

	document.getElementById('progress_info').innerHTML = "";
	//document.getElementById('upload_button').disabled = false;
	document.getElementById('progress_bar').style.display = "none";
	document.form_upload.reset();
}

// Reset the progress bar
function resetProgressBar(){
	get_status_url = "";
	get_data_loop = false;
	seconds = 0;
	minutes = 0;
	hours = 0;
	info_width = 0;
	info_bytes = 0;
	cedric_hold = true;
	total_upload_size = 0;
	total_Kbytes = 0;
	
	document.getElementById('upload_status').style.width = '0px';
	
	if(show_percent_complete){ document.getElementById('percent').innerHTML = '0%'; }
	if(show_files_uploaded){ document.getElementById('uploaded_files').innerHTML = 0; }
	if(show_files_uploaded){ document.getElementById('total_uploads').innerHTML = ''; }
	if(show_current_position){ document.getElementById('current').innerHTML = 0; }
	if(show_current_position){ document.getElementById('total_kbytes').innerHTML = ''; }
	if(show_elapsed_time){ document.getElementById('time').innerHTML = 0; }
	if(show_est_time_left){ document.getElementById('remain').innerHTML = 0; }
	if(show_est_speed){ document.getElementById('speed').innerHTML = 0; }
}

// Stop the upload
function stopUpload(){
	try{ window.stop(); }
	catch(e){
		try{ document.execCommand('Stop'); }
		catch(e){}
	}
}

// Add one upload slot
function addUploadSlot(num){
	if(upload_range < max_upload_slots){
		if(num == upload_range){
			var up = document.getElementById('upload_slots');
			var dv = document.createElement("div");
			
			dv.innerHTML = '<input type="file" name="upfile_' + upload_range + '" size="90" onChange="addUploadSlot('+(upload_range + 1)+')" onKeypress="return handleKey(event)">';
			up.appendChild(dv);
			upload_range++;
		}
	}
}

// Make the progress bar smooth
function smoothCedricStatus(){
	if(info_width < progress_bar_width && !cedric_hold){
		info_width++;
		document.getElementById('upload_status').style.width = info_width + 'px';
	}

	if(get_data_loop){ self.setTimeout("smoothCedricStatus()", info_time_width); }
}

// Make the bytes uploaded smooth
function smoothCedricBytes(){
	if(info_bytes < total_Kbytes && !cedric_hold){
		info_bytes++;
		document.getElementById('current').innerHTML = info_bytes;
	}

	if(get_data_loop){ self.setTimeout("smoothCedricBytes()", info_time_bytes); }
}

// Get the progress of the upload
function getProgressStatus(){
	var jsel = document.createElement('SCRIPT');
	var day = new Date

	jsel.type = 'text/javascript';
	jsel.src = get_status_url + "&rnd_id=" + day.getTime();

	document.body.appendChild(jsel);

	if(get_data_loop){ self.setTimeout("getProgressStatus()", get_status_speed); }
}

// Calculate and display upload stats
function setProgressStatus(bytes_read, lapsed_time, uploaded_files){
	var byte_speed = 0;
	var time_remaining = 0;

	if(lapsed_time > 0){ byte_speed = bytes_read / lapsed_time; }
	if(byte_speed > 0){ time_remaining = Math.round((total_upload_size - bytes_read) / byte_speed); }

	if(cedric_progress_bar == 1){
		if(byte_speed != 0){
			info_time_width = Math.round(total_upload_size * 1000 / (byte_speed * progress_bar_width));
			info_time_bytes = Math.round(1024000 / byte_speed);
		}
		else{
			info_time_width = 200;
			info_time_bytes = 15;
		}
	}
	
	// Calculate percent finished
	var percent_float = bytes_read / total_upload_size;
	var percent = Math.round(percent_float * 100);
	var progress_bar_status = Math.round(percent_float * progress_bar_width);

	// Calculate time remaining
	var remaining_sec = (time_remaining % 60);
	var remaining_min = (((time_remaining - remaining_sec) % 3600) / 60);
	var remaining_hours = ((((time_remaining - remaining_sec) - (remaining_min * 60)) % 86400) / 3600);

	if(remaining_sec < 10){ remaining_sec = '0' + remaining_sec; }
	if(remaining_min < 10){ remaining_min = '0' + remaining_min; }
	if(remaining_hours < 10){ remaining_hours = '0' + remaining_hours; }

	var time_remaining_f = remaining_hours + ':' + remaining_min + ':' + remaining_sec;
	var Kbyte_speed = Math.round(byte_speed / 1024);
	var Kbytes_read = Math.round(bytes_read / 1024);

	if(cedric_progress_bar == 1){
		cedric_hold = false;

		//if(progress_bar_status > info_width && Kbytes_read > info_bytes){ 
			//info_width = progress_bar_status;
			//info_bytes = Kbytes_read; 
		//}
		//else{ cedric_hold = true; }

		info_width = progress_bar_status;
		info_bytes = Kbytes_read;
	}
	else{
		document.getElementById('upload_status').style.width = progress_bar_status + 'px';
		if(show_current_position){ document.getElementById('current').innerHTML = Kbytes_read; }
	}
	
	if(show_percent_complete){ document.getElementById('percent').innerHTML = percent + '%'; }
	if(show_files_uploaded){ document.getElementById('uploaded_files').innerHTML = uploaded_files; }
	if(show_est_time_left){ document.getElementById('remain').innerHTML = time_remaining_f; }
	if(show_est_speed){ document.getElementById('speed').innerHTML = Kbyte_speed; }
}

// Calculate the time spent uploading
function getElapsedTime(){
	seconds++;

	if(seconds == 60){
		seconds = 0;
		minutes++;
	}
    	
	if(minutes == 60){
		minutes = 0;
		hours++;
	}
    	
	var hr = "" + ((hours < 10) ? "0" : "") + hours;
	var min = "" + ((minutes < 10) ? "0" : "") + minutes;
	var sec = "" + ((seconds < 10) ? "0" : "") + seconds;

	document.getElementById('time').innerHTML = hr + ":" + min + ":" + sec;

	if(get_data_loop){ self.setTimeout("getElapsedTime()", 1000); }
}

// Create the AJAX request
function createRequestObject(){
	var req = false;

	if(window.XMLHttpRequest){
		req = new XMLHttpRequest();
		
		if(req.overrideMimeType){ req.overrideMimeType('text/xml'); }
	}
	else if(window.ActiveXObject){
		try{ req = new ActiveXObject("Msxml2.XMLHTTP"); }
		catch(e){
			try{ req = new ActiveXObject("Microsoft.XMLHTTP"); }
			catch(e){}
		}
	}
	
	if(!req){ return false; }
	else{ return req; }
}

// Initialize the progress bar
function iniProgressRequest(){
	var day = new Date
	var ini_script = path_to_ini_status_script + "&rnd_id=" + day.getTime(); 
	
	AJAX_req = createRequestObject();
	
	if(AJAX_req){
		document.getElementById('progress_info').innerHTML = "Initializing Progress Bar ...";
		AJAX_req.onreadystatechange = processReqChange;
		AJAX_req.open("GET", ini_script, true);
		AJAX_req.send(null);
	}
	else{ document.getElementById('progress_info').innerHTML = "Warning: Your browser does not support AJAX"; } 
}

// Initialize the progress bar
function processReqChange(){
	if(AJAX_req.readyState == 4){
		if(AJAX_req.status == 200){
			var xml = AJAX_req.responseXML;
			
			if(xml.getElementsByTagName('error_status').item(0).firstChild.nodeValue == 1){
				document.getElementById('progress_info').innerHTML = xml.getElementsByTagName('error_msg').item(0).firstChild.nodeValue;
				
				if(xml.getElementsByTagName('stop_upload').item(0).firstChild.nodeValue == 1){ stopUpload(); }
			}
			else{
				get_status_speed = xml.getElementsByTagName('get_data_speed').item(0).firstChild.nodeValue;
				total_upload_size = xml.getElementsByTagName('total_bytes').item(0).firstChild.nodeValue;
				total_Kbytes = Math.round(total_upload_size / 1024);
				get_status_url = "uu_get_status.php?temp_dir=" + xml.getElementsByTagName('temp_dir').item(0).firstChild.nodeValue + "&temp_sid=" + xml.getElementsByTagName('temp_sid').item(0).firstChild.nodeValue + "&start_time=" + xml.getElementsByTagName('start_time').item(0).firstChild.nodeValue + "&total_upload_size=" + xml.getElementsByTagName('total_bytes').item(0).firstChild.nodeValue;
				get_data_loop = true;
				
				if(document.form_upload.embedded_upload_results && document.form_upload.embedded_upload_results.value == 1){
					document.getElementById('upload_div').style.display = "none";
				}
				
				document.getElementById('progress_bar').style.display = "";
				document.getElementById('progress_info').innerHTML = "Upload In Progress";
				
				if(show_current_position){ document.getElementById('total_kbytes').innerHTML = total_Kbytes + " "; }
				if(show_elapsed_time){ getElapsedTime(); }
				
				getProgressStatus();
				
				if(cedric_progress_bar == 1){
					if(show_current_position){ smoothCedricBytes(); }
					smoothCedricStatus();
				}
			}
		}
		else{
			document.getElementById('progress_info').innerHTML = "Error: " + AJAX_req.status + " " + AJAX_req.statusText;
			//stopUpload();
		}
	}
}